# Vibe Coding 项目实战导读

> 从 0 到 1 构建真实项目


你好，我是程序员鱼皮，前腾讯全栈开发，全网 200 万粉的 [AI 编程博主](https://space.bilibili.com/12890453)，也是 [AI 导航](https://ai.codefather.cn) 和 [编程导航](https://www.codefather.cn) 等 10+ 自研产品的创造者。

如果你已经看完了【基础必读】的内容，并且成功做出了第一个网页应用，那么恭喜你 —— 你已经迈出了 Vibe Coding 最关键的一步！

但我猜，你现在心里可能会有这样的疑问：

“做出一个简单的待办事项应用确实挺有成就感的，但这离真正能用的产品还差得远吧？”

“我想做一个更复杂的项目，但不知道从哪里开始......”

“看着别人做出来的那些酷炫的 AI 应用，我也想试试，但感觉无从下手。”

别担心，这些想法都很正常。这个板块就是专门为了解决这些问题而设计的。



## 一、为什么要做项目？

在回答 “怎么做项目” 之前，我想先和你聊聊 “为什么要做项目”。

很多同学学完基础教程后，就开始疯狂学各种工具、各种技术，但始终没有做出一个完整的项目。结果就是：学了很多，但感觉什么都不会。

**做项目，是检验学习成果的唯一标准。**

更重要的是，在 Vibe Coding 时代，做项目的门槛已经低到了前所未有的程度。你不需要精通所有技术细节，只需要：

1. 知道自己想做什么
2. 能够清楚地表达需求
3. 会用 AI 工具来实现

这三点，你在【基础必读】中都已经学会了。现在，是时候把这些能力应用到更有挑战性的项目中了。



## 二、这个板块会讲什么？

这个板块的核心内容包括 **项目开发的完整流程** 和 **各种类型的项目实战**。

首先，我会介绍一套经过验证的标准开发流程，从想法需求到最终实现，让你的项目开发更加有条理。这是做好项目的基础，强烈建议先学习这部分。

然后，我会带你实战各种类型的项目。从简单的个人工具开始，比如作品集网站、待办事项应用、Markdown 笔记应用等，这些项目实用性强，适合新手入门。接着是热门的 AI 应用，包括聊天助手、写作助手、图片生成器等，让你掌握 AI 应用开发的核心技能。再往后是更复杂的全栈应用，比如博客系统、问答社区、在线商城等，学习如何处理前后端和数据库。还有微信小程序的开发，从开发到上线的完整流程。

项目做完了，还要学会如何部署上线。我会教你多种部署方式，从最新的 AI 自动部署，到最流行的 Vercel 一键部署，再到专业的服务器部署，让你的项目能够被全世界访问。

最后，如果你不知道做什么项目，我还准备了 100 个项目创意供你参考，总有一个适合你。

此外，这个板块还包含一些扩展内容，比如企业项目开发流程、更多企业级 AI 项目介绍，以及鱼皮的原创项目实战教程等，可以根据需要选择性学习。



## 三、如何使用这个板块？

这个板块的文章不需要全部学完，你可以根据自己的情况灵活选择。

如果你是完全新手，我建议先学习《Vibe Coding 项目开发流程》，了解项目开发的基本方法。然后从个人工具开发开始实践，选择一个简单的项目动手做。这样循序渐进，不会感到太难。

如果你对某个领域特别感兴趣，也可以直接跳到对应的章节。比如你对 AI 应用感兴趣，可以直接学习 AI 应用开发；你想做小程序，可以直接看小程序开发的内容。每篇文章都是相对独立的，不看前面的内容也能理解。

如果你不知道做什么项目，可以先看看项目灵感大全，里面有 100 个项目创意，总有一个能激发你的兴趣。

对于想深入学习的同学，可以在完成基础项目后，继续学习《企业项目开发流程》，了解真实的商业项目是如何开发的。或者学习 [鱼皮的原创项目](https://www.codefather.cn/post/1797431216467001345)，跟着完整的视频和图文教程做出完整的企业级项目。



## 四、学完这个板块，你能收获什么？

通过这个板块的学习和实践，你将能够：

1. 掌握一套完整的项目开发流程
2. 独立完成从想法到产品的全过程
3. 积累至少 2 ~ 3 个可以展示的作品
4. 理解如何用 AI 解决实际问题
5. 建立做项目的信心和方法论

更重要的是，你会发现：**原来做项目可以这么简单、这么有趣！**



## 写在最后

我知道，看到 “项目实战” 这几个字，很多同学会觉得有点紧张。但相信我，在 Vibe Coding 的帮助下，做项目真的没有你想象的那么难。

还记得我在【基础必读】中说过的吗？2025 年的今天，是人类历史上学习编程最容易的时刻。而做项目，也是如此。

你不需要成为技术专家，不需要记住所有的代码语法，你只需要：

- 有一个想做的东西
- 能够清楚地表达你的需求
- 愿意花时间去尝试和迭代

这三点，你都已经具备了。

所以，准备好了吗？让我们一起开始这段激动人心的项目实战之旅吧！

加油，你一定可以的！💪



## 推荐资源

1）鱼皮 AI 导航网站：[AI 资源大全、最新 AI 资讯、免费 AI 教程](https://ai.codefather.cn)

2）编程导航学习圈：[学习路线、编程教程、实战项目、求职宝典、交流答疑](https://www.codefather.cn)

3）程序员面试八股文：[实习/校招/社招高频考点、企业真题解析](https://www.mianshiya.com)

4）程序员写简历神器：[专业模板、丰富例句、直通面试](https://www.laoyujianli.com)

5）1 对 1 模拟面试：[实习/校招/社招面试拿 Offer 必备](https://ai.mianshiya.com)
